SET QUOTED_IDENTIFIER OFF
BEGIN TRY
	BEGIN TRANSACTION;
		DECLARE @SQL NVARCHAR(MAX), @FACILITY_CODE NVARCHAR(10), @CD_CODE NVARCHAR(20), @VISTA_CODE NVARCHAR(20), @FACILITY_UID UNIQUEIDENTIFIER, @VISTA_ID INT,
				@VISTA_SITE_UID UNIQUEIDENTIFIER
		SET @FACILITY_CODE = '$(varFacilityCode)'
		SELECT @VISTA_CODE = V.IDENTIFIER_EXTENSION, @FACILITY_UID = E.IDENTIFIER, @VISTA_ID = V.FK_ENTITY,
			@VISTA_SITE_UID = VSE.IDENTIFIER
		FROM $(varBMS_EIS).dbo.ENTITY AS E 
			INNER JOIN $(varBMS_EIS).dbo.EHL7_ORGANIZATION AS O ON E.PK_ENTITY = O.PFK_ORGANIZATION 
			INNER JOIN $(varBMS_EIS).dbo.EHL7_UID AS F ON  E.PK_ENTITY = F.FK_ENTITY AND F.IDENTIFIER_ROOT = 'CODE'
			INNER JOIN $(varBMS_EIS).dbo.EHL7_ROLE AS R ON R.FK_PLAYER_ENTITY =  E.PK_ENTITY AND R.CLASS_CODE = 'MBR'
			INNER JOIN $(varBMS_EIS).dbo.EHL7_UID AS V ON R.FK_SCOPER_ENTITY = V.FK_ENTITY AND V.IDENTIFIER_ROOT = 'CODE'
			INNER JOIN $(varBMS_EIS).dbo.ENTITY AS VSE ON V.FK_ENTITY = VSE.PK_ENTITY
		WHERE F.IDENTIFIER_EXTENSION = @FACILITY_CODE AND O.CODE_CODE = 'FAC'
		SET @CD_CODE = @VISTA_CODE + '_' + @FACILITY_CODE + '_'

		CREATE TABLE #CONCEPT(CODE NVARCHAR(250), DISPLAY_NAME NVARCHAR(250), CD_TYPE NVARCHAR(250), RN INT)
	
		--DELETE UnavailableReason
		DELETE FROM $(varBMS_EVS).dbo.conceptproperty WHERE codingSchemeName = 'UnavailableReason' AND CONCEPTCODE LIKE '' + @CD_CODE + '' + '%'
		DELETE FROM $(varBMS_EVS).dbo.voc_nested_value_set WHERE codingSchemeName = 'UnavailableReason' AND CONCEPTCODE LIKE '' + @CD_CODE + '' + '%'
		DELETE FROM $(varBMS_EVS).dbo.concept WHERE codingSchemeName = 'UnavailableReason' AND CONCEPTCODE LIKE '' + @CD_CODE + '' + '%'
		
		;WITH BED_CONTROL_UREASON_CTE AS
		(
		  SELECT @CD_CODE + REPLACE(REPLACE(LTRIM(RTRIM(UREASON.UReasonText)), ' ', '_'),'''','_') AS CODE, REPLACE(UREASON.UReasonText, '''','''''') AS DISPLAY_NAME,
			CP.conceptCode AS CD_TYPE,
			ROW_NUMBER() OVER(PARTITION BY UREASON.UReasonText ORDER BY UREASON.UReasonText) AS RN
		  FROM $(varBMS_LOCAL_FACILITY).[dbo].[Bed_Control_UReason] AS UREASON
		  INNER JOIN $(varBMS_EVS).[dbo].[conceptProperty] AS CP ON CP.propertyValue = UREASON.UReasonType
		  WHERE CP.codingSchemeName = 'AdminURType' AND CP.property = 'textualPresentation'
		) 
	     
		INSERT INTO #CONCEPT(CODE, DISPLAY_NAME, CD_TYPE, RN)
		SELECT CODE, DISPLAY_NAME, CD_TYPE, RN
		FROM BED_CONTROL_UREASON_CTE
		WHERE RN = 1
		
		--INSERT UnavailableReason
		SET @SQL = COALESCE(@SQL, ' ') +  ' DECLARE @INCREMENT INT, @CODE NVARCHAR(250) 
			SELECT @INCREMENT = MAX(CAST([uid] AS INT)) FROM $(varBMS_EVS).[dbo].[voc_nested_value_set] WHERE codingSchemeName =''UnavailableReason'' AND valueSetID=''2.12.24.33'''
		SELECT @SQL = @SQL + '
		SET @INCREMENT = @INCREMENT + 1
		INSERT INTO $(varBMS_EVS).[dbo].[concept] ([codingSchemeName], [conceptCode], [firstVersion], [lastVersion], [isActive], [conceptStatus], [isAnonymous], [entityDescription]) VALUES (N''UnavailableReason'', N''' + CP.CODE + ''', 0, 0, 1, N''Active'', NULL, NULL)
		INSERT INTO $(varBMS_EVS).[dbo].[conceptProperty] ([codingSchemeName], [conceptCode], [propertyId], [property], [language], [presentationFormat], [dataType], [isPreferred], [degreeOfFidelity], [matchIfNoContext], [representationalForm], [propertyValue], [aui]) VALUES (N''UnavailableReason'', N''' + CP.CODE + ''', N''' + CAST(NEWID() AS NVARCHAR(50)) + ''', N''textualPresentation'', N''EN'', N''text/plain'', NULL, 1, NULL, NULL, NULL, N''' + CP.DISPLAY_NAME + ''', NULL)
		INSERT INTO $(varBMS_EVS).[dbo].[conceptProperty] ([codingSchemeName], [conceptCode], [propertyId], [property], [language], [presentationFormat], [dataType], [isPreferred], [degreeOfFidelity], [matchIfNoContext], [representationalForm], [propertyValue], [aui]) VALUES (N''UnavailableReason'', N''' + CP.CODE + ''', N''' + CAST(NEWID() AS NVARCHAR(50)) + ''', N''Type'', N''EN'', N''text/plain'', NULL, 0, NULL, NULL, NULL, N''' + CP.CD_TYPE + ''', NULL)
		INSERT INTO $(varBMS_EVS).[dbo].[voc_nested_value_set] ([uid], [valueSetID], [conceptCode], [nestedValueSetID], [isExpandable], [nodeType], [level], [isNestedRoot], [codingSchemeName], [fk_code_reference]) VALUES (CAST(0 as varbinary(8)) + CAST(4 as varbinary(8)) + CAST(@INCREMENT as varbinary(8)), N''2.12.24.33'', N'''+ CP.CODE + ''', N''2.12.24.33'', 0, N''L'', 1, 0, N''UnavailableReason'', NULL)'
		FROM #CONCEPT AS CP
		EXEC sp_executesql @SQL
		
		DELETE FROM #CONCEPT 

		-- WAITING AREA
		--DELETE WaitingArea
		DELETE FROM $(varBMS_EVS).dbo.conceptproperty WHERE codingSchemeName = 'WaitingArea' AND CONCEPTCODE LIKE '' + @CD_CODE + '' + '%'
		DELETE FROM $(varBMS_EVS).dbo.voc_nested_value_set WHERE codingSchemeName = 'WaitingArea' AND CONCEPTCODE LIKE '' + @CD_CODE + '' + '%'
		DELETE FROM $(varBMS_EVS).dbo.concept WHERE codingSchemeName = 'WaitingArea' AND CONCEPTCODE LIKE '' + @CD_CODE + '' + '%'
		
		;WITH BED_CONTROL_WAITAREA_CTE AS
		(
		  SELECT @CD_CODE + REPLACE(REPLACE(LTRIM(RTRIM(WaitAreaName)), ' ', '_'),'''','''''') AS CODE, ISNULL(REPLACE(WaitAreaName, '''',''''''),'') AS DISPLAY_NAME,
			ROW_NUMBER() OVER(PARTITION BY WaitAreaName ORDER BY WaitAreaName) AS RN
		  FROM $(varBMS_LOCAL_FACILITY).[dbo].[Bed_Control_Wait_Area]
		) 
	    
		INSERT INTO #CONCEPT(CODE, DISPLAY_NAME, RN)
		SELECT CODE, DISPLAY_NAME, RN
		FROM BED_CONTROL_WAITAREA_CTE
		WHERE RN = 1
		
		--INSERT WAITING AREA
		SET @SQL = NULL
		SET @SQL = COALESCE(@SQL, ' ') + ' DECLARE @INCREMENT INT, @CODE NVARCHAR(250) 
			SELECT @INCREMENT = MAX(CAST([uid] AS INT)) FROM $(varBMS_EVS).[dbo].[voc_nested_value_set] WHERE codingSchemeName =''WaitingArea'' AND valueSetID=''2.12.24.8'''
		SELECT @SQL = @SQL + '
		SET @INCREMENT = @INCREMENT + 1
		INSERT INTO $(varBMS_EVS).[dbo].[concept] ([codingSchemeName], [conceptCode], [firstVersion], [lastVersion], [isActive], [conceptStatus], [isAnonymous], [entityDescription]) VALUES (N''WaitingArea'', N''' + CODE + ''', 0, 0, 1, N''Active'', NULL, NULL)
		INSERT INTO $(varBMS_EVS).[dbo].[conceptProperty] ([codingSchemeName], [conceptCode], [propertyId], [property], [language], [presentationFormat], [dataType], [isPreferred], [degreeOfFidelity], [matchIfNoContext], [representationalForm], [propertyValue], [aui]) VALUES (N''WaitingArea'', N''' + CODE + ''', N''' + CAST(NEWID() AS NVARCHAR(50)) + ''', N''textualPresentation'', N''EN'', N''text/plain'', NULL, 1, NULL, NULL, NULL, N''' + DISPLAY_NAME + ''', NULL)	
		INSERT INTO $(varBMS_EVS).[dbo].[voc_nested_value_set] ([uid], [valueSetID], [conceptCode], [nestedValueSetID], [isExpandable], [nodeType], [level], [isNestedRoot], [codingSchemeName], [fk_code_reference]) VALUES (CAST(0 as varbinary(8)) + CAST(4 as varbinary(8)) + CAST(@INCREMENT as varbinary(8)), N''2.12.24.8'', N''' + CODE + ''', N''2.12.24.8'', 0, N''L'', 1, 0, N''WaitingArea'', NULL)'
		FROM #CONCEPT
		EXEC sp_executesql @SQL
		
		DELETE FROM #CONCEPT

		--ADT ORDERABLE ITEMS
		--DELETE ADT ORDERABLE ITEMS
		DELETE FROM $(varBMS_EVS).dbo.conceptproperty WHERE codingSchemeName = 'ADTOrderableItem' AND CONCEPTCODE LIKE '' + @CD_CODE + '' + '%'
		DELETE FROM $(varBMS_EVS).dbo.voc_nested_value_set WHERE codingSchemeName = 'ADTOrderableItem' AND CONCEPTCODE LIKE '' + @CD_CODE + '' + '%'
		DELETE FROM $(varBMS_EVS).dbo.concept WHERE codingSchemeName = 'ADTOrderableItem' AND CONCEPTCODE LIKE '' + @CD_CODE + '' + '%'
		
		;WITH BED_CONTROL_ADTORDERABLEITEM_CTE AS
		(
		  SELECT @CD_CODE + CAST(ADT.OIIEN AS NVARCHAR(20)) AS CODE,  REPLACE(ADT.OIName, '','''') AS DISPLAY_NAME,
			CP.conceptCode AS CD_TYPE,
			ROW_NUMBER() OVER(PARTITION BY ADT.OIIEN ORDER BY ADT.OIIEN) AS RN
		  FROM $(varBMS_LOCAL_FACILITY).[dbo].[Bed_Control_ADT_OI] AS ADT
		  INNER JOIN $(varBMS_EVS).[dbo].[conceptProperty] AS OrderableItem on OrderableItem.conceptCode = @VISTA_CODE + '_'  + CAST(ADT.OIIEN AS NVARCHAR(20)) AND REPLACE(OrderableItem.propertyValue, '','''') = REPLACE(ADT.OIName, '','''')
		  INNER JOIN $(varBMS_EVS).[dbo].[conceptProperty] AS CP ON CP.propertyValue = ADT.OIType
		  WHERE OrderableItem.codingSchemeName = 'OrderableItem' AND CP.codingSchemeName = 'OrderableItemType' AND CP.property = 'textualPresentation'
		) 
	    
		INSERT INTO #CONCEPT(CODE, DISPLAY_NAME, CD_TYPE, RN)
		SELECT CODE, DISPLAY_NAME, CD_TYPE, RN
		FROM BED_CONTROL_ADTORDERABLEITEM_CTE
		WHERE RN = 1  
		
		--INSERT ADT ORDERABLE ITEMS
		SET @SQL = NULL
		SET @SQL = COALESCE(@SQL, ' ') + ' DECLARE @INCREMENT INT, @CODE NVARCHAR(100) 
				SELECT @INCREMENT = MAX(CAST([uid] AS INT)) FROM $(varBMS_EVS).[dbo].[voc_nested_value_set] WHERE codingSchemeName =''ADTOrderableItem'' AND valueSetID=''2.12.24.34'''
		SELECT @SQL = @SQL + '
			SET @INCREMENT = @INCREMENT + 1
			INSERT INTO $(varBMS_EVS).[dbo].[concept] ([codingSchemeName], [conceptCode], [firstVersion], [lastVersion], [isActive], [conceptStatus], [isAnonymous], [entityDescription]) VALUES (N''ADTOrderableItem'', N''' + CP.CODE + ''', 0, 0, 1, N''Active'', NULL, NULL)
			INSERT INTO $(varBMS_EVS).[dbo].[conceptProperty] ([codingSchemeName], [conceptCode], [propertyId], [property], [language], [presentationFormat], [dataType], [isPreferred], [degreeOfFidelity], [matchIfNoContext], [representationalForm], [propertyValue], [aui]) VALUES (N''ADTOrderableItem'', N''' + CP.CODE + ''', N''' + CAST(NEWID() AS NVARCHAR(50)) + ''', N''textualPresentation'', N''EN'', N''text/plain'', NULL, 1, NULL, NULL, NULL, N''' + CP.DISPLAY_NAME + ''', NULL)
			INSERT INTO $(varBMS_EVS).[dbo].[conceptProperty] ([codingSchemeName], [conceptCode], [propertyId], [property], [language], [presentationFormat], [dataType], [isPreferred], [degreeOfFidelity], [matchIfNoContext], [representationalForm], [propertyValue], [aui]) VALUES (N''ADTOrderableItem'', N''' + CP.CODE + ''', N''' + CAST(NEWID() AS NVARCHAR(50)) + ''', N''OrderableItemType'', N''EN'', N''text/plain'', NULL, 0, NULL, NULL, NULL, N''' + CP.CD_TYPE + ''', NULL)
			INSERT INTO $(varBMS_EVS).[dbo].[voc_nested_value_set] ([uid], [valueSetID], [conceptCode], [nestedValueSetID], [isExpandable], [nodeType], [level], [isNestedRoot], [codingSchemeName], [fk_code_reference]) VALUES (CAST(0 as varbinary(8)) + CAST(4 as varbinary(8)) + CAST(@INCREMENT as varbinary(8)), N''2.12.24.34'', N''' + CP.CODE + ''', N''2.12.24.34'', 0, N''L'', 1, 0, N''ADTOrderableItem'', NULL)'
		FROM #CONCEPT AS CP
		EXEC sp_executesql @SQL
		
		DROP TABLE #CONCEPT

		--DELETE CONFIG BED BOARD AND EMS NOTIFICTION
		CREATE TABLE #CONFIG(ID INT)
		INSERT INTO #CONFIG(ID)
		SELECT ID FROM $(varBMS).dbo.CONFIG
		WHERE SECTION LIKE '' + 'BedBoardModule ' + '' + CAST(@FACILITY_UID AS NVARCHAR(50)) + '' + '%'
			  OR SECTION LIKE '' + 'EMSNotification ' + '' + CAST(@FACILITY_UID AS NVARCHAR(50)) + '' + '%'

		DELETE CONFIG_EVS FROM $(varBMS).dbo.CONFIG_EVS AS CONFIG_EVS
		INNER JOIN #CONFIG AS DEL ON DEL.ID = CONFIG_EVS.CONFIG_ID

		DELETE C FROM $(varBMS).dbo.CONFIG AS C
		INNER JOIN #CONFIG AS DEL ON DEL.ID = C.ID
		
		DELETE CONFIG_EVS FROM $(varBMS_HISTORY).dbo.CONFIG_EVS_H AS CONFIG_EVS
		INNER JOIN #CONFIG AS DEL ON DEL.ID = CONFIG_EVS.CONFIG_ID

		DELETE C FROM $(varBMS_HISTORY).dbo.CONFIG_H AS C
		INNER JOIN #CONFIG AS DEL ON DEL.ID = C.ID

		DROP TABLE #CONFIG
		
		--INSERT BED BOARD MODULE
		SET @SQL = NULL
		SET @SQL = COALESCE(@SQL, ' ') + ' DECLARE @CONFIG_ID INT '
		SELECT @SQL = @SQL + '
			INSERT INTO $(varBMS).dbo.CONFIG (DOMAIN_ID, USER_NAME, SECTION, CONFIG_KEY, CONFIG_VALUE, CONFIG_TYPE, VALUE_TYPE, FRIENDLY_NAME)
			VALUES (''InfoWorld'', '''', ''BedBoardModule ' + CAST(@FACILITY_UID AS NVARCHAR(50)) +  
				CASE BBModule
					WHEN 'AdmissionOrdersFlag' THEN ' Admission Orders Flag'
					WHEN 'AnticipatedDischargeFlag' THEN ' Anticipated Discharge Flag'
					WHEN 'DischargeAppointmentFlag' THEN ' Discharge Appointments Flag'
					WHEN 'DischargeOrdersFlag' THEN ' Discharge Orders Flag'
					WHEN 'EMSBedCleaningFlag' THEN ' EMS Bed Cleaning Flag'
					WHEN 'TransferOrdersFlag' THEN ' Transfer Orders Flag'
				END
			+ ''', ''CurrentlyInUse'', NULL, ''APP'', ''EVS'', '''')
			SET @CONFIG_ID = IDENT_CURRENT(''$(varBMS).dbo.CONFIG'')
			INSERT INTO $(varBMS).dbo.CONFIG_EVS (CONFIG_ID, CODE, CODE_SYSTEM, CODE_SYSTEM_NAME, DISPLAY_NAME)	
			VALUES (@CONFIG_ID, ''' + UPPER(LEFT(InUse,1))+LOWER(SUBSTRING(InUse,2,LEN(InUse))) + ''', ''2.12.24.15'', ''StrictDecision'', ''' + UPPER(LEFT(InUse,1))+LOWER(SUBSTRING(InUse,2,LEN(InUse))) + ''')'
		FROM $(varBMS_LOCAL_FACILITY).[dbo].[Bed_Control_Modules_Active]
		WHERE (BBModule = 'AdmissionOrdersFlag' OR BBModule = 'AnticipatedDischargeFlag' OR BBModule = 'DischargeAppointmentFlag' 
			  OR BBModule = 'DischargeOrdersFlag' OR BBModule = 'EMSBedCleaningFlag' OR BBModule = 'TransferOrdersFlag')
		EXEC sp_executesql @SQL
		 
		--INSERT EMS NOTIFICATION MODULE
		SET @SQL = NULL
		SET @SQL = COALESCE(@SQL, ' ') + ' DECLARE @CONFIG_ID INT '
		;WITH CTE_LOCATION(LOCATION_NAME) AS
		 (
			SELECT DISTINCT WardGroupText
			FROM $(varBMS_LOCAL_FACILITY).[dbo].[BED_CONTROL_WARD_PARAM]
		 )
		SELECT @SQL = @SQL + '
			INSERT INTO $(varBMS).dbo.CONFIG (DOMAIN_ID, USER_NAME, SECTION, CONFIG_KEY, CONFIG_VALUE, CONFIG_TYPE, VALUE_TYPE, FRIENDLY_NAME)
			VALUES (''InfoWorld'', '''', ''EMSNotification ' + CAST(@FACILITY_UID AS NVARCHAR(50)) + ' ' + EMS.LocationName + ''', ''EMSEmail'', ''' + 
				CASE WHEN RIGHT(EMS.EMSEmailAddr, 1) = ',' THEN LEFT(EMS.EMSEmailAddr, LEN(EMS.EMSEmailAddr) - 1) ELSE EMS.EMSEmailAddr END + ''', ''APP'', ''ST'', '''')
			INSERT INTO $(varBMS).dbo.CONFIG (DOMAIN_ID, USER_NAME, SECTION, CONFIG_KEY, CONFIG_VALUE, CONFIG_TYPE, VALUE_TYPE, FRIENDLY_NAME)
			VALUES (''InfoWorld'', '''', ''EMSNotification ' + CAST(@FACILITY_UID AS NVARCHAR(50)) + ' ' + EMS.LocationName + ''', ''EMSBedControllerEmail'', ''' + 
				CASE WHEN RIGHT(EMS.BCntrlEmailAddr, 1) = ',' THEN LEFT(EMS.BCntrlEmailAddr, LEN(EMS.BCntrlEmailAddr) - 1) ELSE EMS.BCntrlEmailAddr END + ''', ''APP'', ''ST'', '''')
			INSERT INTO $(varBMS).dbo.CONFIG (DOMAIN_ID, USER_NAME, SECTION, CONFIG_KEY, CONFIG_VALUE, CONFIG_TYPE, VALUE_TYPE, FRIENDLY_NAME)
			VALUES (''InfoWorld'', '''', ''EMSNotification ' + CAST(@FACILITY_UID AS NVARCHAR(50)) + ' ' + EMS.LocationName + ''', ''EMSVistaGroupMail'', ''' + 
				CASE WHEN RIGHT(EMS.OtherMailAddr, 1) = ',' THEN LEFT(EMS.OtherMailAddr, LEN(EMS.OtherMailAddr) - 1) ELSE EMS.OtherMailAddr END + ''', ''APP'', ''ST'', '''')
			INSERT INTO $(varBMS).dbo.CONFIG (DOMAIN_ID, USER_NAME, SECTION, CONFIG_KEY, CONFIG_VALUE, CONFIG_TYPE, VALUE_TYPE, FRIENDLY_NAME)
			VALUES (''InfoWorld'', '''', ''EMSNotification ' + CAST(@FACILITY_UID AS NVARCHAR(50)) + ' ' + EMS.LocationName + ''', ''EMSDirty'', NULL, ''APP'', ''EVS'', '''')
			SET @CONFIG_ID = IDENT_CURRENT(''$(varBMS).dbo.CONFIG'')
			INSERT INTO $(varBMS).dbo.CONFIG_EVS (CONFIG_ID, CODE, CODE_SYSTEM, CODE_SYSTEM_NAME, DISPLAY_NAME)	
			VALUES (@CONFIG_ID, ''' + UPPER(LEFT(EMS.EMSDirty,1))+LOWER(SUBSTRING(EMS.EMSDirty,2,LEN(EMS.EMSDirty))) + ''', ''2.12.24.15'', ''StrictDecision'', ''' + UPPER(LEFT(EMS.EMSDirty,1))+LOWER(SUBSTRING(EMS.EMSDirty,2,LEN(EMS.EMSDirty))) + ''')
			INSERT INTO $(varBMS).dbo.CONFIG (DOMAIN_ID, USER_NAME, SECTION, CONFIG_KEY, CONFIG_VALUE, CONFIG_TYPE, VALUE_TYPE, FRIENDLY_NAME)
			VALUES (''InfoWorld'', '''', ''EMSNotification ' + CAST(@FACILITY_UID AS NVARCHAR(50)) + ' ' + EMS.LocationName + ''', ''EMSCleaned'', NULL, ''APP'', ''EVS'', '''')
			SET @CONFIG_ID = IDENT_CURRENT(''$(varBMS).dbo.CONFIG'')
			INSERT INTO $(varBMS).dbo.CONFIG_EVS (CONFIG_ID, CODE, CODE_SYSTEM, CODE_SYSTEM_NAME, DISPLAY_NAME)	
			VALUES (@CONFIG_ID, ''' + UPPER(LEFT(EMS.EMSDirty,1))+LOWER(SUBSTRING(EMS.EMSClean,2,LEN(EMS.EMSClean))) + ''', ''2.12.24.15'', ''StrictDecision'', ''' + UPPER(LEFT(EMS.EMSClean,1))+LOWER(SUBSTRING(EMS.EMSClean,2,LEN(EMS.EMSClean))) + ''')	
			INSERT INTO $(varBMS).dbo.CONFIG (DOMAIN_ID, USER_NAME, SECTION, CONFIG_KEY, CONFIG_VALUE, CONFIG_TYPE, VALUE_TYPE, FRIENDLY_NAME)
			VALUES (''InfoWorld'', '''', ''EMSNotification ' + CAST(@FACILITY_UID AS NVARCHAR(50)) + ' ' + EMS.LocationName + ''', ''EMSBedControllerDirty'', NULL, ''APP'', ''EVS'', '''')
			SET @CONFIG_ID = IDENT_CURRENT(''$(varBMS).dbo.CONFIG'')
			INSERT INTO $(varBMS).dbo.CONFIG_EVS (CONFIG_ID, CODE, CODE_SYSTEM, CODE_SYSTEM_NAME, DISPLAY_NAME)	
			VALUES (@CONFIG_ID, ''' + UPPER(LEFT(EMS.BCntrlDirty,1))+LOWER(SUBSTRING(EMS.BCntrlDirty,2,LEN(EMS.BCntrlDirty))) + ''', ''2.12.24.15'', ''StrictDecision'', ''' + UPPER(LEFT(EMS.BCntrlDirty,1))+LOWER(SUBSTRING(EMS.BCntrlDirty,2,LEN(EMS.BCntrlDirty))) + ''')
			INSERT INTO $(varBMS).dbo.CONFIG (DOMAIN_ID, USER_NAME, SECTION, CONFIG_KEY, CONFIG_VALUE, CONFIG_TYPE, VALUE_TYPE, FRIENDLY_NAME)
			VALUES (''InfoWorld'', '''', ''EMSNotification ' + CAST(@FACILITY_UID AS NVARCHAR(50)) + ' ' + EMS.LocationName + ''', ''EMSBedControllerCleaned'', NULL, ''APP'', ''EVS'', '''')
			SET @CONFIG_ID = IDENT_CURRENT(''$(varBMS).dbo.CONFIG'')
			INSERT INTO $(varBMS).dbo.CONFIG_EVS (CONFIG_ID, CODE, CODE_SYSTEM, CODE_SYSTEM_NAME, DISPLAY_NAME)	
			VALUES (@CONFIG_ID, ''' + UPPER(LEFT(EMS.BCntrlClean,1))+LOWER(SUBSTRING(EMS.BCntrlClean,2,LEN(EMS.BCntrlClean))) + ''', ''2.12.24.15'', ''StrictDecision'', ''' + UPPER(LEFT(EMS.BCntrlClean,1))+LOWER(SUBSTRING(EMS.BCntrlClean,2,LEN(EMS.BCntrlClean))) + ''')	
			INSERT INTO $(varBMS).dbo.CONFIG (DOMAIN_ID, USER_NAME, SECTION, CONFIG_KEY, CONFIG_VALUE, CONFIG_TYPE, VALUE_TYPE, FRIENDLY_NAME)
			VALUES (''InfoWorld'', '''', ''EMSNotification ' + CAST(@FACILITY_UID AS NVARCHAR(50)) + ' ' + EMS.LocationName + ''', ''EMSVistaGroupDirty'', NULL, ''APP'', ''EVS'', '''')
			SET @CONFIG_ID = IDENT_CURRENT(''$(varBMS).dbo.CONFIG'')
			INSERT INTO $(varBMS).dbo.CONFIG_EVS (CONFIG_ID, CODE, CODE_SYSTEM, CODE_SYSTEM_NAME, DISPLAY_NAME)	
			VALUES (@CONFIG_ID, ''' + UPPER(LEFT(EMS.OtherDirty,1))+LOWER(SUBSTRING(EMS.OtherDirty,2,LEN(EMS.OtherDirty))) + ''', ''2.12.24.15'', ''StrictDecision'', ''' + UPPER(LEFT(EMS.OtherDirty,1))+LOWER(SUBSTRING(EMS.OtherDirty,2,LEN(EMS.OtherDirty))) + ''')
			INSERT INTO $(varBMS).dbo.CONFIG (DOMAIN_ID, USER_NAME, SECTION, CONFIG_KEY, CONFIG_VALUE, CONFIG_TYPE, VALUE_TYPE, FRIENDLY_NAME)
			VALUES (''InfoWorld'', '''', ''EMSNotification ' + CAST(@FACILITY_UID AS NVARCHAR(50)) + ' ' + EMS.LocationName + ''', ''EMSVistaGroupCleaned'', NULL, ''APP'', ''EVS'', '''')
			SET @CONFIG_ID = IDENT_CURRENT(''$(varBMS).dbo.CONFIG'')
			INSERT INTO $(varBMS).dbo.CONFIG_EVS (CONFIG_ID, CODE, CODE_SYSTEM, CODE_SYSTEM_NAME, DISPLAY_NAME)	
			VALUES (@CONFIG_ID, ''' + UPPER(LEFT(EMS.OtherClean,1))+LOWER(SUBSTRING(EMS.OtherClean,2,LEN(EMS.OtherClean))) + ''', ''2.12.24.15'', ''StrictDecision'', ''' + UPPER(LEFT(EMS.OtherClean,1))+LOWER(SUBSTRING(EMS.OtherClean,2,LEN(EMS.OtherClean))) + ''')'	
		FROM $(varBMS_LOCAL_FACILITY).[dbo].[Bed_Control_EMS_Notification] AS EMS
		INNER JOIN CTE_LOCATION AS DIVISION on EMS.LocationName = DIVISION.LOCATION_NAME
		EXEC sp_executesql @SQL

		-- VISTA WARDS
		--UPDATE VISTA WARDS
		CREATE TABLE #OLD_WARDS(WARD_NAME NVARCHAR(100), WARD_ID UNIQUEIDENTIFIER, WARD_PK INT, WARD_IEN NVARCHAR(50), DIVISION_NAME NVARCHAR(100), DIVISION_ID UNIQUEIDENTIFIER, DIVISION_PK INT)
		INSERT INTO #OLD_WARDS (WARD_NAME, WARD_ID, WARD_PK, WARD_IEN)
		SELECT P.NAME, E.IDENTIFIER, P.PFK_PLACE, T.IDENTIFIER_EXTENSION
		FROM $(varBMS_EIS).dbo.EHL7_PLACE AS P
			INNER JOIN $(varBMS_EIS).dbo.ENTITY AS E ON P.PFK_PLACE = E.PK_ENTITY
			INNER JOIN $(varBMS_EIS).dbo.EHL7_ROLE AS R ON R.FK_PLAYER_ENTITY = P.PFK_PLACE AND R.CLASS_CODE = 'OWN'
			INNER JOIN $(varBMS_EIS).dbo.EHL7_UID AS T ON T.FK_ENTITY = R.FK_PLAYER_ENTITY AND T.IDENTIFIER_ROOT = 'IEN'
		WHERE P.CODE_CODE = 'WRD' AND R.FK_SCOPER_ENTITY = @VISTA_ID 
		
		;WITH CTE_EXISTING_WARDGROUP(WARD_PK, DIVISION_NAME, DIVISION_ID, DIVISION_PK) AS
		(
			SELECT DISTINCT RWD.FK_PLAYER_ENTITY, O.NAME, E.IDENTIFIER, O.PFK_ORGANIZATION
			FROM $(varBMS_EIS).dbo.EHL7_ORGANIZATION AS O
			INNER JOIN $(varBMS_EIS).dbO.ENTITY AS E ON O.PFK_ORGANIZATION = E.PK_ENTITY
			INNER JOIN $(varBMS_EIS).dbo.EHL7_ROLE AS RFAC ON O.PFK_ORGANIZATION = RFAC.FK_PLAYER_ENTITY AND RFAC.CLASS_CODE = 'MBR'
			INNER JOIN $(varBMS_EIS).dbO.ENTITY AS FAC ON RFAC.FK_SCOPER_ENTITY = FAC.PK_ENTITY
			INNER JOIN $(varBMS_EIS).dbo.EHL7_ROLE AS RWD ON RWD.FK_SCOPER_ENTITY = O.PFK_ORGANIZATION AND RWD.CLASS_CODE = 'SDLOC'
			WHERE O.CODE_CODE = 'WGR' AND FAC.IDENTIFIER = @FACILITY_UID
		)
		
		UPDATE O
			SET DIVISION_ID = DIVISION.DIVISION_ID,
				DIVISION_NAME = DIVISION.DIVISION_NAME,
				DIVISION_PK = DIVISION.DIVISION_PK
		FROM #OLD_WARDS AS O
		INNER JOIN CTE_EXISTING_WARDGROUP AS DIVISION ON DIVISION.WARD_PK = O.WARD_PK
		
		CREATE TABLE #NEW_WARDS(WARD_NAME NVARCHAR(100), WARD_IEN NVARCHAR(100), WARD_TYPE_GROUP NVARCHAR(150), DIVISION_NAME NVARCHAR(100), DIVISION_ID UNIQUEIDENTIFIER, DIVISION_PK INT)
		INSERT INTO #NEW_WARDS(WARD_NAME, WARD_IEN, WARD_TYPE_GROUP, DIVISION_NAME)
		SELECT VistaWardName, CAST(IEN AS NVARCHAR(50)), Specialty, WardGroupText 
		FROM $(varBMS_LOCAL_FACILITY).dbo.Bed_Control_Ward_Param
		
		UPDATE NEW_W
			SET DIVISION_ID = OLD_W.ID,
				DIVISION_PK = OLD_W.PK
		FROM #NEW_WARDS AS NEW_W
		INNER JOIN (SELECT DISTINCT DIVISION_PK AS PK, DIVISION_NAME AS NAME, DIVISION_ID AS ID
					FROM #OLD_WARDS
					WHERE DIVISION_PK IS NOT NULL
					) OLD_W ON OLD_W.NAME = NEW_W.DIVISION_NAME
		
		declare @CTE_DUPLICATE_DIVISION table(DIVISION_NAME nvarchar(100), DIVISION_ID uniqueidentifier)
		insert into @CTE_DUPLICATE_DIVISION(DIVISION_NAME, DIVISION_ID)
		SELECT WardGroupText, NEWID()
		FROM $(varBMS_LOCAL_FACILITY).dbo.Bed_Control_Ward_Param
		group by WardGroupText
		having count(*) > 1
		
		UPDATE NEW_W
			SET DIVISION_ID = DIVISION.DIVISION_ID
		FROM #NEW_WARDS AS NEW_W
		INNER JOIN @CTE_DUPLICATE_DIVISION AS DIVISION ON NEW_W.DIVISION_NAME = DIVISION.DIVISION_NAME
		WHERE NEW_W.DIVISION_ID IS NULL
		
		UPDATE NEW_W
			SET DIVISION_ID = NEWID()
		FROM #NEW_WARDS AS NEW_W 
		WHERE NEW_W.DIVISION_ID IS NULL
		
		CREATE TABLE #BEDS(BED_ID UNIQUEIDENTIFIER, BED_PK INT, WARD_PK INT, DIVISION_PK INT, ROLE_PK INT, NAME_FAMILY NVARCHAR(250))
		INSERT INTO #BEDS(BED_ID, BED_PK, WARD_PK, DIVISION_PK, ROLE_PK, NAME_FAMILY)
		SELECT DISTINCT E.IDENTIFIER, E.PK_ENTITY, R.FK_SCOPER_ENTITY, R1.FK_SCOPER_ENTITY, R2.PK_ROLE, R2.NAME_FAMILY
		FROM $(varBMS_EIS).dbo.EHL7_PLACE AS P
			INNER JOIN $(varBMS_EIS).dbo.ENTITY AS E ON P.PFK_PLACE = E.PK_ENTITY
			INNER JOIN $(varBMS_EIS).dbo.EHL7_ROLE AS R ON R.FK_PLAYER_ENTITY = P.PFK_PLACE AND R.CLASS_CODE = 'LOCE'
			LEFT JOIN $(varBMS_EIS).dbo.EHL7_ROLE AS R1 ON R1.FK_PLAYER_ENTITY = R.FK_SCOPER_ENTITY AND R1.CLASS_CODE = 'SDLOC'
			LEFT JOIN $(varBMS_EIS).dbo.EHL7_ROLE AS R2 ON R2.FK_PLAYER_ENTITY = P.PFK_PLACE AND R2.FK_SCOPER_ENTITY = R1.FK_SCOPER_ENTITY AND R2.CLASS_CODE = 'MNT'
		WHERE P.CODE_CODE = 'BED' AND R.FK_SCOPER_ENTITY IN (SELECT WARD_PK FROM #OLD_WARDS)
		
		--ADD DIVISION
		SET @SQL = NULL
		SET @SQL = COALESCE(@SQL, ' ') + ' DECLARE @P1 INT, @P2 INT '
		
		;WITH CTE_DISTINCT_DIVISION(DIVISION_ID, DIVISION_NAME) AS
		(
			SELECT DISTINCT DIVISION_ID, DIVISION_NAME
			FROM #NEW_WARDS AS NEW_W
			WHERE NEW_W.DIVISION_ID NOT IN (SELECT DISTINCT DIVISION_ID FROM #OLD_WARDS WHERE DIVISION_ID IS NOT NULL )
		)
			
		SELECT @SQL = @SQL + '
				EXEC $(varBMS_EIS).dbo.INS_ENTITY1 @IDENTIFIER=N''' + CAST(NEW_W.DIVISION_ID AS NVARCHAR(50)) + ''',@STATUS_CODE=N''active'',@STATUS_CODE_SYSTEM=N''HL7.EntityStatus'',@STATUS_CODE_SYSTEM_NAME=N''HL7.EntityStatus'',@STATUS_DISPLAY_NAME=N''active'',@DOMAIN_IDENTIFIER=N''InfoWorld'',@ENTITY_TYPE_IDENTIFIER=N''HL7-RIM-V3-Organization'',@LAST_MODIFICATION_TIME=''' + CONVERT(NVARCHAR, GETUTCDATE(), 121) + ''',@TRANSACTION_ID=N''' + CAST(NEWID() AS NVARCHAR(50)) + '''
				SET @P1=-1
				EXEC $(varBMS_EIS).dbo.INS_ORGANIZATION @PFK_ORGANIZATION=@P1 OUTPUT,@DOMAIN_IDENTIFIER=N''InfoWorld'',@ENTITY_TYPE_IDENTIFIER=N''HL7-RIM-V3-Organization'',@ENTITY_IDENTIFIER=N''' + CAST(NEW_W.DIVISION_ID AS NVARCHAR(50)) + ''',@CODE_CODE=N''WGR'',@CODE_CODE_SYSTEM=N''2.12.24.40'',@CODE_CODE_SYSTEM_NAME=N''OrganizationChart'',@CODE_DISPLAY_NAME=N''WARD GROUP'',@DESCRIPTION=NULL,@NAME=N''' + NEW_W.DIVISION_NAME + ''',@NAME_PREFIX=NULL,@NAME_SUFFIX=NULL,@STANDARD_INDUSTRY_CLASS_CODE=NULL,@STANDARD_INDUSTRY_CLASS_CODE_SYSTEM=NULL,@STANDARD_INDUSTRY_CLASS_CODE_SYSTEM_NAME=NULL,@STANDARD_INDUSTRY_CLASS_DISPLAY_NAME=NULL,@EXISTENCE_TIME_LOW=NULL,@EXISTENCE_TIME_HIGH=NULL,@RISK_CODE=NULL,@RISK_CODE_SYSTEM=NULL,@RISK_CODE_SYSTEM_NAME=NULL,@RISK_DISPLAY_NAME=NULL,@HANDLING_CODE=NULL,@HANDLING_CODE_SYSTEM=NULL,@HANDLING_CODE_SYSTEM_NAME=NULL,@HANDLING_DISPLAY_NAME=NULL
				UPDATE #NEW_WARDS SET DIVISION_PK = @P1 WHERE DIVISION_ID = ''' + CAST(NEW_W.DIVISION_ID AS NVARCHAR(50)) + '''
				EXEC $(varBMS_EIS).dbo.INS_UID @FK_ENTITY=@P1,@IDENTIFIER_ROOT=''IEN'',@IDENTIFIER_EXTENSION=N''0''
				EXEC $(varBMS_EIS).dbo.INS_TRAIT_VALUE @ENTITY_IDENTIFIER=N''' + CAST(NEW_W.DIVISION_ID AS NVARCHAR(50)) + ''',@DOMAIN_IDENTIFIER=N''InfoWorld'',@ENTITY_TYPE_IDENTIFIER=N''HL7-RIM-V3-Organization'',@TRAIT_IDENTIFIER=N''IS_ACTIVE'',@TRAIT_VALUE_STRING=N''TRUE'',@TRAIT_VALUE_REAL=NULL,@TRAIT_VALUE_INTEGER=NULL,@TRAIT_VALUE_DATETIME=NULL,@TRAIT_VALUE_BYTE=NULL
				SET @P2=-1
				EXEC $(varBMS_EIS).dbo.INS_ROLE @PK_ROLE=@P2 output,@PLAYER_ENTITY_IDENTIFIER=''' + CAST(NEW_W.DIVISION_ID AS NVARCHAR(50)) + ''',@PLAYER_DOMAIN_IDENTIFIER=N''InfoWorld'',@PLAYER_ENTITY_TYPE_IDENTIFIER=N''HL7-RIM-V3-Organization'',@SCOPER_ENTITY_IDENTIFIER=''' + CAST(@FACILITY_UID AS NVARCHAR(50)) + ''',@SCOPER_DOMAIN_IDENTIFIER=N''InfoWorld'',@SCOPER_ENTITY_TYPE_IDENTIFIER=N''HL7-RIM-V3-Organization'',@CLASS_CODE=N''MBR'',@CLASS_CODE_SYSTEM=N''2.16.840.1.113883.5.110'',@CLASS_CODE_SYSTEM_NAME=N''RoleClass'',@CLASS_DISPLAY_NAME=N''member'',@CODE_CODE=N''WARD_GROUP'',@CODE_CODE_SYSTEM=N''2.16.840.1.113883.5.111'',@CODE_CODE_SYSTEM_NAME=N''RoleCode'',@CODE_DISPLAY_NAME=N''Ward Group'',@NEGATION_IND=NULL,@NAME_FAMILY=NULL,@NAME_FIRST_GIVEN=NULL,@NAME_SECOND_GIVEN=NULL,@NAME_PREFIX=NULL,@NAME_SUFFIX=NULL,@STATUS_CODE=NULL,@STATUS_CODE_SYSTEM=NULL,@STATUS_CODE_SYSTEM_NAME=NULL,@STATUS_DISPLAY_NAME=NULL,@EFFECTIVE_TIME_LOW=NULL,@EFFECTIVE_TIME_HIGH=NULL,@CERTIFICATE_TEXT=NULL,@CONFIDENTIALITY_CODE=NULL,@CONFIDENTIALITY_CODE_SYSTEM=NULL,@CONFIDENTIALITY_CODE_SYSTEM_NAME=NULL,@CONFIDENTIALITY_DISPLAY_NAME=NULL,@QUANTITY_NUMERATOR_VALUE=NULL,@QUANTITY_NUMERATOR_UNIT=NULL,@QUANTITY_DENOMINATOR_VALUE=NULL,@QUANTITY_DENOMINATOR_UNIT=NULL,@POSITION_NUMBER=NULL,@APPROACH_SITE_CODE=NULL,@APPROACH_SITE_CODE_SYSTEM=NULL,@APPROACH_SITE_CODE_SYSTEM_NAME=NULL,@APPROACH_SITE_DISPLAY_NAME=NULL,@TARGET_SITE_CODE=NULL,@TARGET_SITE_CODE_SYSTEM=NULL,@TARGET_SITE_CODE_SYSTEM_NAME=NULL,@TARGET_SITE_DISPLAY_NAME=NULL,@GAUGE_VALUE=NULL,@GAUGE_UNIT=NULL,@JOB_CODE=NULL,@JOB_CODE_SYSTEM=NULL,@JOB_CODE_SYSTEM_NAME=NULL,@JOB_DISPLAY_NAME=NULL,@JOB_TITLE_NAME=NULL,@JOB_CLASS_CODE=NULL,@JOB_CLASS_CODE_SYSTEM=NULL,@JOB_CLASS_CODE_SYSTEM_NAME=NULL,@JOB_CLASS_DISPLAY_NAME=NULL,@OCCUPATION_CODE=NULL,@OCCUPATION_CODE_SYSTEM=NULL,@OCCUPATION_CODE_SYSTEM_NAME=NULL,@OCCUPATION_DISPLAY_NAME=NULL,@SALARY_TYPE_CODE=NULL,@SALARY_TYPE_CODE_SYSTEM=NULL,@SALARY_TYPE_CODE_SYSTEM_NAME=NULL,@SALARY_TYPE_DISPLAY_NAME=NULL,@SALARY_VALUE=NULL,@SALARY_CURRENCY=NULL,@HAZARD_EXPOSURE_TEXT=NULL,@PROTECTIVE_EQUIPMENT_TEXT=NULL,@RECERTIFICATION_TIME=NULL,@VIP_CODE=NULL,@VIP_CODE_SYSTEM=NULL,@VIP_CODE_SYSTEM_NAME=NULL,@VIP_DISPLAY_NAME=NULL,@EQUIVALENCE_IND=NULL,@DATA_TYPE=N''ROL'''
		FROM CTE_DISTINCT_DIVISION AS NEW_W
		EXEC sp_executesql @SQL
			
		--UPDATE ROLE (WARD - DIVISION) UPDATE TRAIT (TYPE GROUP AND IS ACTIVE)
		SET @SQL = NULL
		SET @SQL = COALESCE(@SQL, ' ') + ' DECLARE @P1 INT '
		SELECT @SQL = @SQL + '
				EXEC $(varBMS_EIS).dbo.UPD_TRAIT_VALUE @ENTITY_IDENTIFIER=N''' + CAST(OLD_W.WARD_ID AS NVARCHAR(50)) + ''',@DOMAIN_IDENTIFIER=N''InfoWorld'',@ENTITY_TYPE_IDENTIFIER=N''HL7-RIM-V3-Place'',@TRAIT_IDENTIFIER=N''TYPE_GROUP'',@TRAIT_VALUE_STRING=N''' + NEW_W.WARD_TYPE_GROUP + ''',@TRAIT_VALUE_REAL=NULL,@TRAIT_VALUE_INTEGER=NULL,@TRAIT_VALUE_DATETIME=NULL,@TRAIT_VALUE_BYTE=NULL
				EXEC $(varBMS_EIS).dbo.UPD_TRAIT_VALUE @ENTITY_IDENTIFIER=N''' + CAST(OLD_W.WARD_ID AS NVARCHAR(50)) + ''',@DOMAIN_IDENTIFIER=N''InfoWorld'',@ENTITY_TYPE_IDENTIFIER=N''HL7-RIM-V3-Place'',@TRAIT_IDENTIFIER=N''IS_ACTIVE'',@TRAIT_VALUE_STRING=N''TRUE'',@TRAIT_VALUE_REAL=NULL,@TRAIT_VALUE_INTEGER=NULL,@TRAIT_VALUE_DATETIME=NULL,@TRAIT_VALUE_BYTE=NULL
				SET @P1=-1
				EXEC $(varBMS_EIS).dbo.UPD_ROLE @PK_ROLE=@P1 OUTPUT,@PLAYER_ENTITY_IDENTIFIER=N''' + CAST(OLD_W.WARD_ID AS NVARCHAR(50)) + ''',@PLAYER_DOMAIN_IDENTIFIER=N''InfoWorld'',@PLAYER_ENTITY_TYPE_IDENTIFIER=N''HL7-RIM-V3-Place'',@SCOPER_ENTITY_IDENTIFIER=N''' + CAST(NEW_W.DIVISION_ID AS NVARCHAR(50)) + ''',@SCOPER_DOMAIN_IDENTIFIER=N''InfoWorld'',@SCOPER_ENTITY_TYPE_IDENTIFIER=N''HL7-RIM-V3-Organization'',@CLASS_CODE=N''SDLOC'',@CLASS_CODE_SYSTEM=N''2.16.840.1.113883.5.110'',@CLASS_CODE_SYSTEM_NAME=N''RoleClass'',@CLASS_DISPLAY_NAME=N''service delivery location'',@CODE_CODE=N''WARD'',@CODE_CODE_SYSTEM=N''2.16.840.1.113883.5.111'',@CODE_CODE_SYSTEM_NAME=N''RoleCode'',@CODE_DISPLAY_NAME=N''Ward'',@NEGATION_IND=NULL,@NAME_FAMILY=NULL,@NAME_FIRST_GIVEN=NULL,@NAME_SECOND_GIVEN=NULL,@NAME_PREFIX=NULL,@NAME_SUFFIX=NULL,@STATUS_CODE=NULL,@STATUS_CODE_SYSTEM=NULL,@STATUS_CODE_SYSTEM_NAME=NULL,@STATUS_DISPLAY_NAME=NULL,@EFFECTIVE_TIME_LOW=NULL,@EFFECTIVE_TIME_HIGH=NULL,@CERTIFICATE_TEXT=NULL,@CONFIDENTIALITY_CODE=NULL,@CONFIDENTIALITY_CODE_SYSTEM=NULL,@CONFIDENTIALITY_CODE_SYSTEM_NAME=NULL,@CONFIDENTIALITY_DISPLAY_NAME=NULL,@QUANTITY_NUMERATOR_VALUE=NULL,@QUANTITY_NUMERATOR_UNIT=NULL,@QUANTITY_DENOMINATOR_VALUE=NULL,@QUANTITY_DENOMINATOR_UNIT=NULL,@POSITION_NUMBER=NULL,@APPROACH_SITE_CODE=NULL,@APPROACH_SITE_CODE_SYSTEM=NULL,@APPROACH_SITE_CODE_SYSTEM_NAME=NULL,@APPROACH_SITE_DISPLAY_NAME=NULL,@TARGET_SITE_CODE=NULL,@TARGET_SITE_CODE_SYSTEM=NULL,@TARGET_SITE_CODE_SYSTEM_NAME=NULL,@TARGET_SITE_DISPLAY_NAME=NULL,@GAUGE_VALUE=NULL,@GAUGE_UNIT=NULL,@JOB_CODE=NULL,@JOB_CODE_SYSTEM=NULL,@JOB_CODE_SYSTEM_NAME=NULL,@JOB_DISPLAY_NAME=NULL,@JOB_TITLE_NAME=NULL,@JOB_CLASS_CODE=NULL,@JOB_CLASS_CODE_SYSTEM=NULL,@JOB_CLASS_CODE_SYSTEM_NAME=NULL,@JOB_CLASS_DISPLAY_NAME=NULL,@OCCUPATION_CODE=NULL,@OCCUPATION_CODE_SYSTEM=NULL,@OCCUPATION_CODE_SYSTEM_NAME=NULL,@OCCUPATION_DISPLAY_NAME=NULL,@SALARY_TYPE_CODE=NULL,@SALARY_TYPE_CODE_SYSTEM=NULL,@SALARY_TYPE_CODE_SYSTEM_NAME=NULL,@SALARY_TYPE_DISPLAY_NAME=NULL,@SALARY_VALUE=NULL,@SALARY_CURRENCY=NULL,@HAZARD_EXPOSURE_TEXT=NULL,@PROTECTIVE_EQUIPMENT_TEXT=NULL,@RECERTIFICATION_TIME=NULL,@VIP_CODE=NULL,@VIP_CODE_SYSTEM=NULL,@VIP_CODE_SYSTEM_NAME=NULL,@VIP_DISPLAY_NAME=NULL,@EQUIVALENCE_IND=NULL,@DATA_TYPE=N''ROL'''
		FROM #NEW_WARDS AS NEW_W
		INNER JOIN #OLD_WARDS AS OLD_W ON OLD_W.WARD_IEN = NEW_W.WARD_IEN
		EXEC sp_executesql @SQL
			
		--DELETE old association between ward-division, bed-division
		CREATE TABLE #DELETE_WARD_DIVISION(DIVISION_PK INT, WARD_PK INT)
		INSERT INTO #DELETE_WARD_DIVISION(DIVISION_PK, WARD_PK)
		SELECT OLD_W.DIVISION_PK, OLD_W.WARD_PK FROM
		(SELECT WARD_IEN, DIVISION_PK, WARD_PK FROM #OLD_WARDS WHERE DIVISION_PK IS NOT NULL) OLD_W
		INNER JOIN #NEW_WARDS AS NEW_W ON NEW_W.WARD_IEN = OLD_W.WARD_IEN AND NEW_W.DIVISION_PK <> OLD_W.DIVISION_PK
		UNION
		SELECT OLD_W.DIVISION_PK, OLD_W.WARD_PK FROM
		(SELECT WARD_IEN, DIVISION_PK, WARD_PK FROM #OLD_WARDS WHERE DIVISION_PK IS NOT NULL) OLD_W
		LEFT OUTER JOIN #NEW_WARDS AS NEW_W ON NEW_W.WARD_IEN = OLD_W.WARD_IEN
		WHERE NEW_W.WARD_IEN IS NULL
		
		DELETE WD_ROLE FROM $(varBMS_EIS).dbo.EHL7_ROLE AS WD_ROLE
		INNER JOIN #DELETE_WARD_DIVISION AS DEL ON DEL.DIVISION_PK = WD_ROLE.FK_SCOPER_ENTITY AND DEL.WARD_PK = WD_ROLE.FK_PLAYER_ENTITY
		
		;WITH CTE_DELETE_BED(ROLE_PK) AS
		(
			SELECT DISTINCT BED.ROLE_PK
			FROM #BEDS AS BED
			INNER JOIN #DELETE_WARD_DIVISION AS DEL ON BED.WARD_PK = DEL.WARD_PK AND BED.DIVISION_PK = DEL.DIVISION_PK
			WHERE BED.DIVISION_PK IS NOT NULL		
		)
		 
		DELETE BD_ROLE FROM $(varBMS_EIS).dbo.EHL7_ROLE AS BD_ROLE
		INNER JOIN CTE_DELETE_BED AS DEL ON DEL.ROLE_PK = BD_ROLE.PK_ROLE

		DROP TABLE #DELETE_WARD_DIVISION
		
		--UPDATE ROLE (BED - DIVISION)
		SET @SQL = NULL
		SET @SQL = COALESCE(@SQL, ' ') + ' DECLARE @P1 INT '
		
		;WITH CTE_DISTINCT_BED(BED_ID, WARD_PK) AS
		(
			SELECT DISTINCT BED_ID, WARD_PK
			FROM #BEDS
		)
			
		SELECT @SQL = @SQL + '		
			SET @P1=-1
			EXEC $(varBMS_EIS).dbo.UPD_ROLE @PK_ROLE=@P1 OUTPUT,@PLAYER_ENTITY_IDENTIFIER=N''' + CAST(B.BED_ID AS NVARCHAR(50)) + ''',@PLAYER_DOMAIN_IDENTIFIER=N''InfoWorld'',@PLAYER_ENTITY_TYPE_IDENTIFIER=N''HL7-RIM-V3-Place'',@SCOPER_ENTITY_IDENTIFIER=N''' + CAST(NEW_W.DIVISION_ID AS NVARCHAR(50)) + ''',@SCOPER_DOMAIN_IDENTIFIER=N''InfoWorld'',@SCOPER_ENTITY_TYPE_IDENTIFIER=N''HL7-RIM-V3-Organization'',@CLASS_CODE=N''MNT'',@CLASS_CODE_SYSTEM=N''2.16.840.1.113883.5.110'',@CLASS_CODE_SYSTEM_NAME=N''RoleClass'',@CLASS_DISPLAY_NAME=N''maintained entity'',@CODE_CODE=NULL,@CODE_CODE_SYSTEM=NULL,@CODE_CODE_SYSTEM_NAME=NULL,@CODE_DISPLAY_NAME=NULL,@NEGATION_IND=NULL, @NAME_FAMILY=' + CASE WHEN COMMENT.NAME_FAMILY IS NULL THEN 'NULL' ELSE '''' +  COMMENT.NAME_FAMILY + '''' END + ',@NAME_FIRST_GIVEN=NULL,@NAME_SECOND_GIVEN=NULL,@NAME_PREFIX=NULL,@NAME_SUFFIX=NULL,@STATUS_CODE=NULL,@STATUS_CODE_SYSTEM=NULL,@STATUS_CODE_SYSTEM_NAME=NULL,@STATUS_DISPLAY_NAME=NULL,@EFFECTIVE_TIME_LOW=NULL,@EFFECTIVE_TIME_HIGH=NULL,@CERTIFICATE_TEXT=NULL,@CONFIDENTIALITY_CODE=NULL,@CONFIDENTIALITY_CODE_SYSTEM=NULL,@CONFIDENTIALITY_CODE_SYSTEM_NAME=NULL,@CONFIDENTIALITY_DISPLAY_NAME=NULL,@QUANTITY_NUMERATOR_VALUE=NULL,@QUANTITY_NUMERATOR_UNIT=NULL,@QUANTITY_DENOMINATOR_VALUE=NULL,@QUANTITY_DENOMINATOR_UNIT=NULL,@POSITION_NUMBER=NULL,@APPROACH_SITE_CODE=NULL,@APPROACH_SITE_CODE_SYSTEM=NULL,@APPROACH_SITE_CODE_SYSTEM_NAME=NULL,@APPROACH_SITE_DISPLAY_NAME=NULL,@TARGET_SITE_CODE=NULL,@TARGET_SITE_CODE_SYSTEM=NULL,@TARGET_SITE_CODE_SYSTEM_NAME=NULL,@TARGET_SITE_DISPLAY_NAME=NULL,@GAUGE_VALUE=NULL,@GAUGE_UNIT=NULL,@JOB_CODE=NULL,@JOB_CODE_SYSTEM=NULL,@JOB_CODE_SYSTEM_NAME=NULL,@JOB_DISPLAY_NAME=NULL,@JOB_TITLE_NAME=NULL,@JOB_CLASS_CODE=NULL,@JOB_CLASS_CODE_SYSTEM=NULL,@JOB_CLASS_CODE_SYSTEM_NAME=NULL,@JOB_CLASS_DISPLAY_NAME=NULL,@OCCUPATION_CODE=NULL,@OCCUPATION_CODE_SYSTEM=NULL,@OCCUPATION_CODE_SYSTEM_NAME=NULL,@OCCUPATION_DISPLAY_NAME=NULL,@SALARY_TYPE_CODE=NULL,@SALARY_TYPE_CODE_SYSTEM=NULL,@SALARY_TYPE_CODE_SYSTEM_NAME=NULL,@SALARY_TYPE_DISPLAY_NAME=NULL,@SALARY_VALUE=NULL,@SALARY_CURRENCY=NULL,@HAZARD_EXPOSURE_TEXT=NULL,@PROTECTIVE_EQUIPMENT_TEXT=NULL,@RECERTIFICATION_TIME=NULL,@VIP_CODE=NULL,@VIP_CODE_SYSTEM=NULL,@VIP_CODE_SYSTEM_NAME=NULL,@VIP_DISPLAY_NAME=NULL,@EQUIVALENCE_IND=NULL,@DATA_TYPE=N''ROL'''
		FROM CTE_DISTINCT_BED AS B
		INNER JOIN #OLD_WARDS AS OLD_W ON OLD_W.WARD_PK = B.WARD_PK
		INNER JOIN #NEW_WARDS AS NEW_W ON NEW_W.WARD_IEN = OLD_W.WARD_IEN
		LEFT JOIN (
					SELECT MAX(ROLE_PK) AS ROLE_PK, BED_ID AS BED_ID, DIVISION_PK AS DIVISION_PK
					FROM #BEDS 
					WHERE DIVISION_PK IS NOT NULL
					GROUP BY BED_ID, DIVISION_PK
				   ) NAME_FAMILY ON NAME_FAMILY.BED_ID = B.BED_ID AND NAME_FAMILY.DIVISION_PK = NEW_W.DIVISION_PK
	    LEFT JOIN #BEDS AS COMMENT ON COMMENT.ROLE_PK = NAME_FAMILY.ROLE_PK
		EXEC sp_executesql @SQL
		
		--DELETE OLD DIVISION
		CREATE TABLE #DELETE_DIVISION(PK INT)
		INSERT INTO #DELETE_DIVISION(PK)   
		SELECT OLD_W.DIVISION_PK FROM
		(SELECT DIVISION_PK FROM #OLD_WARDS WHERE DIVISION_PK IS NOT NULL) AS OLD_W
		LEFT OUTER JOIN #NEW_WARDS AS NEW_W ON NEW_W.DIVISION_PK = OLD_W.DIVISION_PK
		WHERE  NEW_W.DIVISION_PK IS NULL
	    
 		DELETE SCOPER_ROLE FROM $(varBMS_EIS).dbo.EHL7_ROLE AS SCOPER_ROLE
		INNER JOIN #DELETE_DIVISION AS DEL ON DEL.PK = SCOPER_ROLE.FK_SCOPER_ENTITY

		DELETE PLAYER_ROLE FROM $(varBMS_EIS).dbo.EHL7_ROLE AS PLAYER_ROLE
		INNER JOIN #DELETE_DIVISION AS DEL ON DEL.PK = PLAYER_ROLE.FK_PLAYER_ENTITY
		
		DELETE TV FROM $(varBMS_EIS).dbo.TRAIT_VALUE AS TV
		INNER JOIN #DELETE_DIVISION AS DEL ON DEL.PK = TV.FK_ENTITY

		DELETE WARDGROUP_UID FROM $(varBMS_EIS).dbo.EHL7_UID AS WARDGROUP_UID
		INNER JOIN #DELETE_DIVISION AS DEL ON DEL.PK = WARDGROUP_UID.FK_ENTITY

		DELETE O FROM $(varBMS_EIS).dbo.EHL7_ORGANIZATION AS O
		INNER JOIN #DELETE_DIVISION AS DEL ON DEL.PK  = O.PFK_ORGANIZATION

		DELETE E FROM $(varBMS_EIS).dbo.ENTITY AS E
		INNER JOIN #DELETE_DIVISION AS DEL ON DEL.PK = E.PK_ENTITY
		
		DROP TABLE #BEDS
		DROP TABLE #OLD_WARDS
		DROP TABLE #NEW_WARDS
		DROP TABLE #DELETE_DIVISION
	
		-- DISCHARGE APPOINTMENT CLINICS
		CREATE TABLE #CLINICS (ID UNIQUEIDENTIFIER)
		INSERT INTO #CLINICS (ID)
		SELECT E.IDENTIFIER
		FROM $(varBMS_EIS).dbo.ENTITY AS E
			INNER JOIN $(varBMS_EIS).dbo.EHL7_ORGANIZATION AS O ON E.PK_ENTITY = O.PFK_ORGANIZATION AND O.CODE_CODE = 'HLOC'
			INNER JOIN $(varBMS_EIS).dbo.EHL7_ROLE AS R ON O.PFK_ORGANIZATION = R.FK_PLAYER_ENTITY AND R.FK_SCOPER_ENTITY = @VISTA_ID AND CLASS_CODE = 'MBR'
			INNER JOIN $(varBMS_EIS).dbo.EHL7_UID AS C ON C.FK_ENTITY = O.PFK_ORGANIZATION AND C.IDENTIFIER_ROOT = 'IEN'
			INNER JOIN $(varBMS_LOCAL_FACILITY).[dbo].[Bed_Control_Discharge_Clinic] AS DC ON C.IDENTIFIER_EXTENSION = DC.DCIEN
			
		SET @SQL = NULL
		SET @SQL = COALESCE(@SQL, ' ') + ' DECLARE @P1 INT '
		SELECT @SQL = @SQL + '
			SET @P1 = -1		
			EXEC $(varBMS).[dbo].[usp_Insert_Hospital_Location_Appointment] @ID = @P1 OUTPUT, @DOMAIN_ID = ''InfoWorld'', @HOSPITAL_LOCATION_UID = ''' + CAST(C.ID AS NVARCHAR(50)) + ''', @FACILITY_UID = ''' + CAST(@FACILITY_UID AS NVARCHAR(50)) + ''', @VISTA_SITE_UID = ''' + CAST(@VISTA_SITE_UID AS NVARCHAR(50)) + ''''
		FROM #CLINICS AS C
		LEFT OUTER JOIN $(varBMS).dbo.HOSPITAL_LOCATION_APPOINTMENT AS HOS ON HOS.HOSPITAL_LOCATION_UID = C.ID
		WHERE HOS.HOSPITAL_LOCATION_UID IS NULL	
		EXEC sp_executesql @SQL
		
		DELETE HOS
		FROM $(varBMS).dbo.HOSPITAL_LOCATION_APPOINTMENT AS HOS
		LEFT OUTER JOIN #CLINICS AS C ON C.ID = HOS.HOSPITAL_LOCATION_UID
		WHERE C.ID IS NULL AND HOS.FACILITY_UID = @FACILITY_UID
		
		DELETE HOS
		FROM $(varBMS_HISTORY).dbo.HOSPITAL_LOCATION_APPOINTMENT_h AS HOS
		LEFT OUTER JOIN #CLINICS AS C ON C.ID = HOS.HOSPITAL_LOCATION_UID
		WHERE C.ID IS NULL  AND HOS.FACILITY_UID = @FACILITY_UID
		 
		DROP TABLE #CLINICS
		SELECT 'Site Options - successfully updated'
	COMMIT TRANSACTION;
END TRY
BEGIN CATCH
	SELECT ERROR_MESSAGE()
	ROLLBACK TRANSACTION;
END CATCH;
SET QUOTED_IDENTIFIER ON

